<?php
/**
 * WPML extension for Greyd.Blocks.
 */
namespace greyd\blocks;

if( ! defined( 'ABSPATH' ) ) exit;

new WPML_Extension();
class WPML_Extension {

	/**
	 * Constructor
	 */
	public function __construct() {
		
		// wpml translation editor support
		add_filter( 'wpml_found_strings_in_block', array($this, 'wpml_decode_dynamic_content_attribute'), 10, 2 );
		add_filter( 'wpml_update_strings_in_block', array($this, 'wpml_encode_dynamic_content_attribute'), 10, 3 );
	}

	/**
	 * Decode strings inside 'dynamic_content' attribute.
	 *
	 * When post with Gutenberg blocks is being send for translation
	 * WPML parses blocks to find translatable strings. The attribute
	 * 'dynamic_content' is being saved urlencoded, which makes it
	 * necessary to decode it first before beeing readable.
	 *
	 * @param array  $strings                 already found strings.
	 * @param \WP_Block_Parser_Block $block   block being parsed.
	 * 
	 * @filter 'wpml_found_strings_in_block'
	 * @see sitepress-multilingual-cms\addons\wpml-page-builders\classes\Integrations\Gutenberg\strings-in-block\class-collection.php
	 */
	public function wpml_decode_dynamic_content_attribute( $strings, $block ) {
		if ( $block->blockName == "greyd/dynamic" ) {
			foreach ( $strings as $key => $value ) {
				$strings[$key]->value = urldecode( $value->value );
			}
			// debug($strings);
		}
		return $strings;
	}

	/**
	 * Encode strings inside 'dynamic_content' attribute.
	 * 
	 * @param \WP_Block_Parser_Block $block    block being saved.
	 * @param array $string_translations       array with string translations for current String Package.
	 * @param string $lang                     language of translated post/block.
	 * 
	 * @filter 'wpml_update_strings_in_block'
	 * @see sitepress-multilingual-cms\addons\wpml-page-builders\classes\Integrations\Gutenberg\strings-in-block\class-collection.php
	 */
	public function wpml_encode_dynamic_content_attribute( $block, $string_translations, $lang ) {
		if ( $block->blockName == "greyd/dynamic" ) {
			if ( isset($block->attrs["dynamic_content"]) ) {
				foreach ( $block->attrs["dynamic_content"] as $key => $value ) {
					$block->attrs["dynamic_content"][$key]["dvalue"] = rawurlencode( $value["dvalue"] );
				}
			}
			// debug($block);
		}
		return $block;
	}
}
