<?php
/**
 * Dynamic block features.
 * - Template Block
 * - dynamic content
 * - dynamic tags
 */
namespace Greyd\Dynamic;

if ( ! defined( 'ABSPATH' ) ) exit;

new Manage($config);
class Manage {

	/**
	 * Holds the plugin config
	 */
	private $config;

	/**
	 * Constructor
	 */
	public function __construct($config) {

		// check if Gutenberg is active.
		if (!function_exists('register_block_type')) return;

		// set config
		$this->config = (object) $config;

		// setup
		if (!function_exists('get_plugin_data')) require_once(ABSPATH . '/wp-admin/includes/plugin.php');
		$this->config->plugin_version = get_plugin_data($this->config->plugin_file)['Version'];

		// enqueue dynamic scripts
		add_action( 'enqueue_block_editor_assets', array($this, 'register_blocks_assets') );

		// register block
		add_action( 'init', array($this, 'register_blocks'), 99 );

	}

	/**
	 * Register and enqueue dynamic scripts for the editor
	 */
	public function register_blocks_assets() {

		if ( method_exists( '\greyd\blocks\render', 'render_dynamic' ) ) return;
		

		$js_uri = plugin_dir_url(__FILE__).'assets/js';

		// editor script
		wp_register_script(
			'greyd-dynamic-editor',
			trailingslashit( $js_uri ).'editor.js',
			array( 'greyd-tools', 'greyd-components', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-data', 'wp-i18n', 'lodash' ),
			$this->config->plugin_version
		);
		wp_enqueue_script('greyd-dynamic-editor');

		// dynamic script
		wp_register_script(
			'greyd-dynamic',
			trailingslashit( $js_uri ).'dynamic.js',
			array( 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash' ),
			$this->config->plugin_version
		);
		wp_enqueue_script('greyd-dynamic');
		
		// dtag format script
		wp_register_script(
			'greyd-format-dtag',
			trailingslashit( $js_uri ).'format-dtag.js',
			array( 'greyd-tools', 'greyd-components', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash' ),
			$this->config->plugin_version
		);
		wp_enqueue_script('greyd-format-dtag');

		// autocompleters script
		wp_register_script(
			'greyd-dynamic-autocompleter',
			trailingslashit( $js_uri ).'autocompleter.js',
			array( 'greyd-format-dtag', 'greyd-tools', 'greyd-components', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash' ),
			$this->config->plugin_version
		);
		wp_enqueue_script('greyd-dynamic-autocompleter');
		
		// add script translations
		if ( function_exists('wp_set_script_translations') ) {
			wp_set_script_translations( 'greyd-dynamic-editor', 'greyd_hub', $this->config->plugin_path.'/languages' );
			wp_set_script_translations( 'greyd-dynamic', 'greyd_hub', $this->config->plugin_path.'/languages' );
			wp_set_script_translations( 'greyd-format-dtag', 'greyd_hub', $this->config->plugin_path.'/languages' );
			wp_set_script_translations( 'greyd-dynamic-autocompleter', 'greyd_hub', $this->config->plugin_path.'/languages' );
		}
		
	}

	/**
	 * Blockeditor
	 */
	public function register_blocks() {

		if ( method_exists( '\greyd\blocks\render', 'render_dynamic' ) ) return;

		$js_uri = plugin_dir_url(__FILE__).'assets/js';

		// register script
		wp_register_script(
			'greyd-dynamic-editor-script',
			trailingslashit( $js_uri ).'block-dynamic.js',
			array( 'greyd-dynamic', 'greyd-tools', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash', 'wp-core-data', 'wp-edit-post' ),
			$this->config->plugin_version
		);

		// add script translations
		if ( function_exists('wp_set_script_translations') ) {
			wp_set_script_translations( 'greyd-dynamic-editor-script', 'greyd_hub', $this->config->plugin_path.'/languages' );
		}
		
		// register dynamic template block
		register_block_type( 'greyd/dynamic', array(
			'supports' => array( 'anchor' => true ),
			'attributes' => array(
				'anchor'          => array( 'type' => 'string' ),
				'postId'          => array( 'type' => 'string' ), // backend helper to get the queried post in loop
				'dynamic_parent'  => array( 'type' => 'string' ), // dynamic template backend helper
				'dynamic_value'   => array( 'type' => 'string' ), // dynamic template frontend helper
				'dynamic_fields'  => array( 'type' => 'array' ),
				'inline_css'      => array( 'type' => 'string', 'default' => '' ),
				'inline_css_id'   => array( 'type' => 'string', 'default' => '' ),
				'template'        => array( 'type' => 'string', 'default' => '' ),
				'dynamic_content' => array( 'type' => 'array', 'items' => array(
					'type' => 'object', 'properties' => array(
						'dkey'   => array( 'type' => 'string' ),
						'dtype'  => array( 'type' => 'string' ),
						'dtitle' => array( 'type' => 'string' ),
						'dvalue' => array( 'type' => 'string' ),
					),
				), 'default' => array() ),
			),
			'uses_context' => array(  "postId", "postType", "queryId" ),
			'editor_script' => 'greyd-dynamic-editor-script',
			// 'render_callback' =>  array('\greyd\blocks\render', 'render_dynamic'),
			// 'render_callback' =>  array('\greyd\blocks\dynamic\Render', 'render_dynamic'),
			'render_callback' =>  array('\Greyd\Dynamic\Render_Blocks', 'render_dynamic'),
		) );
	
	}

}