<?php

namespace Greyd\Query;

if ( ! defined( 'ABSPATH' ) ) exit;

new Enqueue($config);
class Enqueue {

	/**
	 * Holds the plugin config
	 */
	private $config;

	/**
	 * Constructor
	 */
	public function __construct( $config ) {

		// check if Gutenberg is active.
		if (!function_exists('register_block_type')) return;

		// set config
		$this->config = (object) $config;

		// setup
		if (!function_exists('get_plugin_data')) require_once(ABSPATH . '/wp-admin/includes/plugin.php');
		$this->config->plugin_version = get_plugin_data($this->config->plugin_file)['Version'];
		$this->config->assets_url = trailingslashit(plugin_dir_url(__FILE__));

		// enqueue scripts
		add_action( 'wp_enqueue_scripts', array( $this, 'add_frontend_scripts' ) );
		if ( is_admin() ) {
			/**
			 * 'enqueue_block_assets' action should be used here. 
			 * @see features/blocks/enqueue.php
			 */
			$action = \Greyd\Helper::is_active_plugin('gutenberg/gutenberg.php') ? 'enqueue_block_assets' : 'current_screen';
			add_action( $action, array($this, 'register_block_editor_styles') );
			add_action( 'enqueue_block_editor_assets', array($this, 'register_block_editor_scripts') );
		}
	}

	/**
	 * Enqueue frontend scripts.
	 * @action wp_enqueue_scripts
	 */
	public function add_frontend_scripts() {

		$version = $this->config->plugin_version;
	
		// register the post slider script
		if ( ! wp_style_is( 'greyd-query-postslider-script', 'registered') ) {
			wp_register_script(
				'greyd-query-postslider-script',
				$this->config->assets_url.'assets/js/post-slider.js',
				null,
				$version,
				true
			);
		}
	
		// enqueue the script
		if ( ! wp_style_is( 'greyd-query-postslider-script', 'enqueued') ) {
			wp_enqueue_script( 'greyd-query-postslider-script' );
		}

		// register the live filter script
		if ( ! wp_style_is( 'greyd-query-livefilter-script', 'registered') ) {
			wp_register_script(
				'greyd-query-livefilter-script',
				$this->config->assets_url.'assets/js/live-filter.js',
				null,
				$version,
				true
			);
			wp_localize_script(
				'greyd-query-livefilter-script',
				'WP_REST_API',
				array(
					'root' => esc_url_raw( str_replace( 'wp-json', '?rest_route=', rest_url() ) ),
					'paths' => array(
						'livequery' => 'greyd/v1/livequery/'
					),
					'lang' => \Greyd\Helper::get_language_code()
				)
			);
		}

		// register the main style
		wp_register_style(
			'greyd-post-slider-style',
			$this->config->assets_url.'assets/css/style.css',
			array( ),
			$version
		);
		wp_enqueue_style('greyd-post-slider-style');
		
		// dequeue deprecated style
		wp_dequeue_style( 'greyd-query-style' );
		wp_dequeue_style( 'greyd-query-frontend-style' );
	}

	/**
	 * Enqueue block styles.
	 * @action enqueue_block_assets
	 */
	public function register_block_editor_styles() {

		if ( ! is_admin() ) return;

		// add preview style
		add_editor_style( $this->config->assets_url.'assets/css/editor-blocks.css' );

	}
	
	/**
	 * Register and enqueue all the scripts for the editor.
	 * @action enqueue_block_editor_assets
	 */
	public function register_block_editor_scripts() {

		// add editor script
		wp_register_script(
			'greyd-query-editor-script',
			$this->config->assets_url.'assets/js/editor.js',
			array( 'greyd-tools', 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components', 'wp-i18n', 'lodash', 'wp-core-data', 'wp-edit-post' ),
			$this->config->plugin_version
		);
		wp_enqueue_script( 'greyd-query-editor-script' );

		// add script translations
		if ( function_exists('wp_set_script_translations') ) {
			wp_set_script_translations( 'greyd-query-editor-script', 'greyd_hub', $this->config->plugin_path.'/languages' );
		}
	}
}